/* $Id: timing.c,v 1.12 1998/07/20 21:06:18 ericb Exp $ */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Taken from E1431 library, heavily modified by Eric Backus */

#include "sema.h"

SHORTSIZ16 EXPORT
e1432_get_ttltrg_lines(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 * ttltrg)
{
    SHORTSIZ16 ttltrg_clock, ttltrg_satrg;
    SHORTSIZ16 error;

    TRACE_PRINTF(0, ("e1432_get_ttltrg_lines(0x%p, %d, 0x%p)\n",
		     hw, ID, ttltrg));

    /* Get the clock and satrg settings */
    error = e1432_get_ttltrg_clock(hw, ID, &ttltrg_clock);
    if (error)
	return error;
    error = e1432_get_ttltrg_satrg(hw, ID, &ttltrg_satrg);
    if (error)
	return error;

    /* Check for Octane-compatible pair */
    if (ttltrg_satrg == E1432_TTLTRG_0 &&
	ttltrg_clock == E1432_TTLTRG_1)
	*ttltrg = E1432_TTLTRG_01;
    else if (ttltrg_satrg == E1432_TTLTRG_2 &&
	     ttltrg_clock == E1432_TTLTRG_3)
	*ttltrg = E1432_TTLTRG_23;
    else if (ttltrg_satrg == E1432_TTLTRG_4 &&
	     ttltrg_clock == E1432_TTLTRG_5)
	*ttltrg = E1432_TTLTRG_45;
    else if (ttltrg_satrg == E1432_TTLTRG_6 &&
	     ttltrg_clock == E1432_TTLTRG_7)
	*ttltrg = E1432_TTLTRG_67;
    else
	return i1432_id_print_error(hw, ID, ERR1432_PARAMETER_UNEQUAL);

    return 0;
}

SHORTSIZ16 EXPORT
e1432_set_ttltrg_lines(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 ttltrg)
{
    SHORTSIZ16 error;
    LONGSIZ32 ttltrg_clock, ttltrg_satrg;

    TRACE_PRINTF(0, ("e1432_set_ttltrg_lines(0x%p, %d, %d)\n",
		     hw, ID, ttltrg));

    switch (ttltrg)
    {
    case E1432_TTLTRG_01:
	ttltrg_satrg = E1432_TTLTRG_0;
	ttltrg_clock = E1432_TTLTRG_1;
	break;
    case E1432_TTLTRG_23:
	ttltrg_satrg = E1432_TTLTRG_2;
	ttltrg_clock = E1432_TTLTRG_3;
	break;
    case E1432_TTLTRG_45:
	ttltrg_satrg = E1432_TTLTRG_4;
	ttltrg_clock = E1432_TTLTRG_5;
	break;
    case E1432_TTLTRG_67:
	ttltrg_satrg = E1432_TTLTRG_6;
	ttltrg_clock = E1432_TTLTRG_7;
	break;
    default:
	return i1432_id_print_error(hw, ID, ERR1432_ILLEGAL_TTLTRG_LINE);
    }

    /* Set clock and satrg lines */
    error = i1432_set_mod(hw, ID, E1432_TTLTRG_CLOCK_REG,
			  E1432_CMD_SET_TTLTRG_CLOCK,
			  ttltrg_clock);
    if (error)
	return error;
    error = i1432_set_mod(hw, ID, E1432_TTLTRG_SATRG_REG,
			  E1432_CMD_SET_TTLTRG_SATRG,
			  ttltrg_satrg);
    if (error)
	return error;

    return 0;
}

/*
 *********************************************************************
 Set the bit for automatically setting up groups.  Returns 0 if all
 ok, else return negative error number.
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_get_auto_group_meas(E1432ID hw, SHORTSIZ16 ID,
			  SHORTSIZ16 * state)
{
    E1432_GROUP_LIST_NODE *gn;
    E1432_CHAN_LIST_NODE *cn;
    E1432_MODULE_LIST_NODE *mn;
    SHORTSIZ16 error, temp;

    TRACE_PRINTF(0, ("e1432_get_auto_group_meas(0x%p, %d, 0x%p)\n",
		     hw, ID, state));

    /* check for valid id */
    error = i1432_checkID(hw, ID);
    if (error)
	return error;

    /* check if channel or group */
    if (ID < 0)
    {
	/* iterate thru group making sure that all parameters match */
	gn = i1432_get_group_node(hw, ID);
	cn = gn->chanlist;
	if (cn)
	{
	    /* get first parameter */
	    error = e1432_get_auto_group_meas(hw, cn->chanID, state);
	    if (error)
		return error;
	    cn = cn->next;
	}
	else
	    /* hmmm, no channels in group */
	    return i1432_print_error(ERR1432_NO_CHANNEL);
	while (cn)		/* check each channel */
	{
	    error = e1432_get_auto_group_meas(hw, cn->chanID, &temp);
	    if (error)
		return error;
	    if (temp != *state)
		return i1432_print_error(ERR1432_PARAMETER_UNEQUAL);
	    cn = cn->next;
	}
    }
    else
    {
	/* get lone channel */
	error = i1432_get_module_from_chan(hw, ID, &mn);
	if (error)
	    return error;
	*state = mn->autoGroup;
    }
    return 0;
}

/*
 *********************************************************************
 Sets the auto group meas bit.  Returns 0 if all ok, else return
 negative error number.
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_set_auto_group_meas(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 state)
{
    E1432_GROUP_LIST_NODE *gn;
    E1432_CHAN_LIST_NODE *cn;
    E1432_MODULE_LIST_NODE *mn;
    SHORTSIZ16 error;

    TRACE_PRINTF(0, ("e1432_set_auto_group_meas(0x%p, %d, %d)\n",
		     hw, ID, state));

    /* check for valid id */
    error = i1432_checkID(hw, ID);
    if (error)
	return error;

    /* check input parameter */
    if (!((state == E1432_AUTO_GROUP_MEAS_ON)
	  || (state == E1432_AUTO_GROUP_MEAS_OFF)))
	return i1432_print_error(ERR1432_ILLEGAL_GROUP_MEAS_STATE);

    /* check if channel or group */
    if (ID < 0)
    {
	/* iterate thru group */
	gn = i1432_get_group_node(hw, ID);
	cn = gn->chanlist;
	while (cn)
	{
	    error = e1432_set_auto_group_meas(hw, cn->chanID, state);
	    if (error)
		return error;
	    cn = cn->next;
	}
    }
    else
    {
	/* set lone channel */
	error = i1432_get_module_from_chan(hw, ID, &mn);
	if (error)
	    return error;
	mn->autoGroup = state;
    }
    return 0;
}
